# README for 2021-modle-paper-001/data/output/hoxd_encode_chip

This folder contains the input files obtained by running the [ENCODE Transcription Factor and Histone ChIP-Seq processing pipeline v2.2.0](https://github.com/ENCODE-DCC/chip-seq-pipeline2/tree/v2.2.0) workflow.

Refer to [ENCODE's documentation](https://github.com/ENCODE-DCC/chip-seq-pipeline2/tree/v2.2.0) and [run_chipseq2_encode.sh](https://github.com/paulsengroup/2021-modle-paper-001-data-analysis/blob/v2.0.1/run_chipseq2_encode.sh) for instructions on how to run the workflow.

The workflow was ran using [genome_tsv/v4/mm10.tsv](https://storage.googleapis.com/encode-pipeline-genome-data/genome_tsv/v4/mm10.tsv) as well as CTCF and RAD21 ChIP-seq sequencing data from:
- [GSM2418858](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM2418858) - WT_IgG_ChIPSeq
- [GSM2418859](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM2418859) - WT_Rad21_ChIPSeq
- [GSM2418860](https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSM2418860) - WT_CTCF_ChIPSeq


## File description
The workflow produces several files and folders. `2021-modle-paper-001/data/output/hoxd_encode_chip` contains the following files:
- `checksums.sha256`: SHA256 checksums. Use `shasum -c checksums.sha256` to check file integrity.
- `prjna356611*_fold_change.bigwig`: fold change over control for CTCF and RAD21.
- `prjna356611*_narrow_peaks.bed.gz`: narrow peaks for CTCF and RAD21.
- `README.md`: This file.
