# README for 2021-modle-paper-001/data/output/heatmap_comparison_pt1

This folder contains the input files obtained by running the [heatmap_comparison_pt1](https://github.com/paulsengroup/2021-modle-paper-001-data-analysis/blob/v2.0.1/workflows/heatmap_comparison_pt1.nf) Nextflow workflow.

Refer to [paulsengroup/2021-modle-paper-001-data-analysis/README.md](https://github.com/paulsengroup/2021-modle-paper-001-data-analysis/blob/v2.0.1/README.md) for instructions on how to run the workflow.


## File description
The workflow produces the following files and folders:
- `ab_comp`: dissimilarity scores computed with `modle_tools eval` grouped by A/B compartment.
- `checksums.sha256`: SHA256 checksums. Use `shasum -c checksums.sha256` to check file integrity.
- `correlation`: input files and plots used to generate Supplementary Fig. 3.
- `dumps`: This folder contains three TSVs with the raw and balanced pixel values for a pair of cooler files over 5 regions of interest. File names have the following syntax: `cooler1_vs_cooler2.tsv.gz`, where `cooler1` and `cooler2` are the names (without extension) of the files used to generate the TSVs. Columns `count1` and `balanced1` refer to pixels from `cooler1`, while `count2` and `balanced2` refer to pixels from `cooler2`. These files were mainly used to compute the
    correlation values shown in the paper for OpenMM vs MoDLE.
- `eval`: This folder contains the output of `modle_tools eval` run for all possible pairs of files. See previous point for how to decipher file names. Files suffixed with `_filtered` were generated by intersecting `modle_tools eval` output with the architectural stripes called by Stripenn (see `stripenn/` folder).
- `matrices`: This folder contains several single and multi-resolution cooler files generated from Micro-C data and with MoDLE and OpenMM MD simulations. Files suffixed with `_subsampled` were generated with `cooltools random-sample`. Files suffixed with `_transformed` were generated with `modle_tools transform` using the difference of Gaussians followed by a discretization step.
- `README.md`: This file.
- `stripenn`: This folder contains the list of architectural stripes identified by Stripenn.
