# README for 2021-modle-paper-001/data/output/extrusion_barrier_param_optimization

This folder contains the input files obtained by running the [extrusion_barrier_param_optimization](https://github.com/paulsengroup/2021-modle-paper-001-data-analysis/blob/v2.0.1/workflows/extrusion_barrier_param_optimization.nf) Nextflow workflow.

Refer to [paulsengroup/2021-modle-paper-001-data-analysis/README.md](https://github.com/paulsengroup/2021-modle-paper-001-data-analysis/blob/v2.0.1/README.md) for instructions on how to run the workflow.


## File description
The workflow produces the following files and folders:
- `checksums.sha256`: SHA256 checksums. Use `shasum -c checksums.sha256` to check file integrity.
- `mcools/`: Multi-resolution coolers generated from the cooler matrices found in folder `simulations/` (see below).
             `GRCh38_H1_optimized_barriers_microc_003_000.mcool_hof_ensemble.mcool` was generated by merging `GRCh38_H1_optimized_barriers_microc_003_???.mcool` matrices using `cooler merge`.
- `optimized_barriers/`: Folder containing the output of the GA optimization described in Methods part 10.
                         `*.tar.gz` files contain the output of an optimization round.
                         `*.log` are the log files produced by the optimization script [scripts/optimize_extrusion_barrier_params_islands.py](https://github.com/paulsengroup/2021-modle-paper-001-data-analysis/blob/v2.0.1/scripts/optimize_extrusion_barrier_params_islands.py).
                         `*_extrusion_barriers.bed.gz` is the extrusion barrier generated from the fittest individual that ever lived in a given optimization run.
                         `*extrusion_barriers_simulated_chip*` files were used to generate parts of Fig. 6.
- `README.md`: This file.
- `simulations/`: Output produced by MoDLE using extrusion barrier annotations generated from the hall of fame of the last optimization run (run &#35;3).
                 `GRCh38_H1_barriers_RAD21_occupancy.cool` was generated using the extrusion barrier annotation using RAD21 data (see [preprocessing](https://github.com/paulsengroup/2021-modle-paper-001-data-analysis/blob/v2.0.1/workflows/preprocessing.nf) workflow).
